---
title: Broken Object Level Authorization vulnerability detection · Cloudflare
  API Shield docs
description: A Broken Object Level Authorization (BOLA) vulnerability is where
  an application or API fails to properly verify if a user has permission to
  access specific data.
lastUpdated: 2025-11-07T16:57:24.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/api-shield/security/bola-vulnerability-detection/
  md: https://developers.cloudflare.com/api-shield/security/bola-vulnerability-detection/index.md
---

A Broken Object Level Authorization (BOLA) vulnerability is where an application or API fails to properly verify if a user has permission to access specific data.

Bugs in the application or API allow attackers to bypass authorization checks and access potentially sensitive information by manipulating and iterating through object identifiers.

Vulnerabilities can occur at any time, including in the original application's deployment. However, changes or upgrades to authentication and authorization policies can also introduce these bugs.

BOLA vulnerabilities are as dangerous as an account takeover. Successfully exploiting a BOLA vulnerability allows the attacker to access or change data that they should not have ownership over.

Cloudflare labels endpoints with BOLA risk when we detect two distinct signals common with attacks exploiting BOLA: **Parameter pollution** and **Enumeration**.

## Enumeration

Cloudflare continually profiles all sessions on a per-endpoint basis and detects anomalous sessions that successfully request many unique data points from an API endpoint against what is normal.

Note

Sessions that have more random behavior or repetition have a higher chance of triggering an alert.

The BOLA enumeration label requires an endpoint to have seen at least 10,000 sessions before being eligible for outlier detection.

Enumeration example

**Endpoint**: `GET /api/v1/users/{userId}/credit-cards`

* **Normal behavior**: Users request credit cards using only their own `userId`.
* **Attack behavior**: Attackers request hundreds of `userId` values per session by brute-force iterating through `userIds` found via other methods.
* **Result**: If the origin authorization policy is broken for this endpoint, the attacker gains credit card information on every user account they request it for.

## Parameter pollution

Cloudflare detects anomalies where one or more successful requests containing a value in an expected path, query string, header, or cookie have that value duplicated in an unexpected, similar location.

This behavior may be indicative of attackers trying to confuse the API's authorization system and bypass security controls.

Parameter pollution example

**Endpoint**: `GET /api/v1/orders/{orderId}`

* **Normal behavior**: `orderId` sent in a path variable like `GET /api/v1/orders/12345`
* **Attacker behavior**: `orderId` is also sent as a query parameter, triggering old, undocumented code that looks for orders in the query parameter and happens to lack an authorization check: `GET /api/v1/orders/12345?orderId=67890`
* **Result**: By passing in a fake order or an order that the attacker owns (`12345`), they are able to trigger the old, undocumented code and access an order that they do not own (`67890`)

## Process

API Shield searches for and highlights BOLA attacks on your APIs. Cloudflare learns visitor traffic patterns over time to know when API access to specific objects is likely a BOLA enumeration attack. We inform you what API endpoints are being targeted by automatically labeling them using the following [risk labels](https://developers.cloudflare.com/api-shield/management-and-monitoring/endpoint-labels/#risk-labels):

`cf-risk-bola-enumeration`: Automatically added when an endpoint experiences successful responses with drastic differences in the number of unique elements requested by different user sessions.

`cf-risk-bola-pollution`: Automatically added when an endpoint experiences successful responses where parameters are found in multiple places in the request, as opposed to what is expected from the API's schema.

If you see one of these labels on your API endpoints, check its authorization policy with your developer team to find any authorization bugs. Additionally, you can reach out to Cloudflare for a customized report about the behavior, including attacker identifiers that you can use to confirm attack reach and impact.

BOLA attack information can be found in your [Security Overview](#security-overview), [Security Analytics](#security-analytics), and [Endpoint details](#endpoint-details).

### Security Overview

If BOLA vulnerabilities have been detected on your endpoints, you can view a summary of the attack and suggestions to mitigate it via the Cloudflare dashboard.

1. In the Cloudflare dashboard, go to the **Security** page.

   [Go to **Overview**](https://dash.cloudflare.com/?to=/:account/:zone/security/overview)

2. Go to **API abuse** or **All suggestions**.

3. Depending on the type of attack, select **Review traffic from potential BOLA enumeration attack** or **Review traffic from potential parameter pollution attack** to view details of the attack and suggested actions.

4. Select **View all affected endpoints** or **View details** on a specific endpoint to review suspicious sessions in [Web Assets](#endpoint-details).

Cloudflare evaluates your session requests for both enumeration and parameter pollution attacks and provides you with a list of at-risk endpoints and the number of anomalous sessions where an attack was detected. You can follow the suggested actions to address your BOLA vulnerabilities and prevent future attacks against your endpoints.

Note

If the insight has been archived but attacks are still present, you can filter by **Show archived**.

### Security Analytics

You can view analytics of your zone's traffic profile and suspicious requests associated with enumeration or parameter pollution attacks in the Cloudflare dashboard.

[Go to **Analytics**](https://dash.cloudflare.com/?to=/:account/:zone/security/analytics)

Filter requests depending on the type of attack detected in your zone, including the hashed session IDs found in the attack and the corresponding BOLA vulnerability risk label, to see an analysis of your request activity from the past seven days. This filter includes all traffic from suspected attacker sessions, so you can evaluate other actions that they are taking against your zone.

This does not filter by specific endpoints.

Review the top statistics and details of managed API endpoints, paths and values targeted by the attack, source IPs, source user agents, and source fingerprints.

Cloudflare recommends that you observe your traffic profile for any anomalies in its normal behavior.

### Endpoint details

You can expand the endpoint details in Web Assets to access information on suspicious sessions' activity on the endpoint, including both enumeration attack and parameter pollution attack details.

[Go to **Web assets**](https://dash.cloudflare.com/?to=/:account/:zone/security/web-assets)

Under **Security overview**, select **View attack** to review affected sessions with its associated IP addresses and JA4 fingerprints.

You can export the `.csv` file containing all the IP addresses and JA4 fingerprints for all or only a specific session.

Note

The hashed session ID is used for privacy purposes and only as a unique identifier for a specific session. It cannot be un-hashed. It will not match your customer values in your application or database.

The details specify the parameter that was affected, the number of sessions involved in the attack, and how far their behavior deviated from baseline.

If unauthorized access to the parameter was obtained, consider the potential impact to your application, users, and data. As a best practice, consult with your application and API developers to confirm unauthorized access by reviewing your API origin logs for the IP address and JA4 fingerprint of the abusive sessions.

You can view attack data in [Security Analytics](#security-analytics).

[Go to **Analytics**](https://dash.cloudflare.com/?to=/:account/:zone/security/analytics)

The managed endpoint will be automatically filtered in the request activity from the past seven days. You can also filter by suspicious IP addresses and fingerprints found in the attack details.

***

## Availability

Broken Object Level Authorization vulnerability detection is only available for Enterprise customers. If you are an Enterprise customer interested in this product, contact your account team.
