---
title: Centrify (SAML) · Cloudflare One docs
description: Learn how to integrate Centrify as a SAML identity provider with
  Cloudflare One.
lastUpdated: 2025-11-24T22:12:32.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/centrify-saml/
  md: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/centrify-saml/index.md
---

Centrify secures access to infrastructure, DevOps, cloud, and other modern enterprise so you can prevent the number one cause of breaches: privileged access abuse.

## Set up Centrify as a SAML provider

## 1. Create an application in Centrify

1. Log in to your **Centrify** admin portal and select **Apps**.

2. Select **Add Web Apps**.

3. Select the **Custom** tab.

4. Next to the **SAML** icon, select **Add**.

   ![Centrify Settings Add Application details page with template text](https://developers.cloudflare.com/_astro/saml-centrify-3.CEH90Xdy_ZMwrJK.webp)

5. Enter the required information for your application.

6. Select **Save**.

7. Select **Settings** in the left pane.

8. In the middle menu pane, select **Trust**.

9. Choose the **Manual Configuration** option.

10. In the **SP Entity ID** and **Assertion Consumer Service (ACS) URL fields**, enter the following URL:

    ```txt
    https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/callback
    ```

    You can find your team name in [Cloudflare One](https://one.dash.cloudflare.com) under **Settings** > **Team name and domain** > **Team name**.

11. Select **Save**.

12. In the middle menu pane, select **User Access**.

13. Select **Add**. The **Select Role** dialog displays.

14. Complete your roles access assignments. The Role rules display on the **User Access** card.

15. In the **User Access** card's middle menu pane, select **SAML Response**.

16. Select **Active** > **Add** to create a new **Attribute Name**, **Email**.

    ![Centrify SAML Response card with Settings Email Attribute selected](https://developers.cloudflare.com/_astro/saml-centrify-9.BpHIxUlM_Z14DHjz.webp)

17. Enter the user email addresses in the **Attribute Value** field.

18. Select **Save**.

19. Select **Settings** again from the left menu pane, and **Trust**.

20. Select the **Manual Configuration** option.

### 2. Add Centrify to Cloudflare One

1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Integrations** > **Identity providers**.

2. Under **Your identity providers**, select **Add new identity provider**.

3. Select **SAML**.

4. Copy and paste the corresponding information from Centrify into the fields.

5. (Optional) To enable SCIM, refer to [Synchronize users and groups](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-saml/#synchronize-users-and-groups).

6. (Optional) Under **Optional configurations**, configure [additional SAML options](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/generic-saml/#optional-configurations).

7. Select **Save**.

To test that your connection is working, go to **Integrations** > **Identity providers** and select **Test** next to the identity provider you want to test.

## Download SP metadata (optional)

Some IdPs allow administrators to upload metadata files from their SP (service provider).

To get your Cloudflare metadata file:

1. Download your unique SAML metadata file at the following URL:

   ```txt
   https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/saml-metadata
   ```

2. Save the file in XML format.

3. Upload the XML document to your **Centrify** account.

## Example API configuration

```json
{
  "config": {
    "issuer_url": "https://abc123.my.centrify.com/baaa2117-0ec0-4d76-84cc-abccb551a123",
    "sso_target_url": "https://abc123.my.centrify.com/applogin/appKey/baaa2117-0ec0-4d76-84cc-abccb551a123/customerId/abc123",
    "attributes": ["email"],
    "email_attribute_name": "",
    "sign_request": false,
    "idp_public_cert": "MIIDpDCCAoygAwIBAgIGAV2ka+55MA0GCSqGSIb3DQEBCwUAMIGSMQswCQYDVQQGEwJVUzETMBEG\nA1UEC.....GF/Q2/MHadws97cZg\nuTnQyuOqPuHbnN83d/2l1NSYKCbHt24o"
  },
  "type": "saml",
  "name": "centrify saml example"
}
```
