---
title: Features and plans · Cloudflare DNS docs
description: Review information on all Cloudflare DNS features and their availability.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/reference/all-features/
  md: https://developers.cloudflare.com/dns/reference/all-features/index.md
---

Cloudflare provides the following features for different [plans](https://www.cloudflare.com/plans/).

## Features

### Advanced nameservers

**Link:** [Advanced nameservers](https://developers.cloudflare.com/dns/foundation-dns/advanced-nameservers/)

**Feature availability**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Included with [Foundation DNS](https://developers.cloudflare.com/dns/foundation-dns/)

### CNAME flattening

**Link:** [CNAME flattening](https://developers.cloudflare.com/dns/cname-flattening/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Can customize**

Pro plans and above can customize

* **Free:** No
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Custom nameservers

**Link:** [Custom nameservers](https://developers.cloudflare.com/dns/nameservers/custom-nameservers/)

**Feature availability**

* **Free:** No
* **Pro:** No
* **Business:** Yes
* **Enterprise:** Yes

### DNS analytics

**Link:** [DNS analytics](https://developers.cloudflare.com/dns/additional-options/analytics/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Maximum time interval (zone)**

* **Free:** 7 days
* **Pro:** 31 days
* **Business:** 31 days
* **Enterprise:** 62 days

**Maximum time interval (account)**

* **Free:** 7 days
* **Pro:** 7 days
* **Business:** 7 days
* **Enterprise:** 62 days

**Historical data (zone)**

* **Free:** 8 days
* **Pro:** 31 days
* **Business:** 31 days
* **Enterprise:** 62 days

**Historical data (account)**

* **Free:** 8 days
* **Pro:** 8 days
* **Business:** 8 days
* **Enterprise:** 62 days

### DNSSEC

**Link:** [DNSSEC](https://developers.cloudflare.com/dns/dnssec/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### DNS Firewall

**Link:** [DNS Firewall](https://developers.cloudflare.com/dns/dns-firewall/)

**Feature availability**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Paid add-on

**Historical data**

* **Free:** N/A
* **Pro:** N/A
* **Business:** N/A
* **Enterprise:** 62 days

**Maximum time interval**

* **Free:** N/A
* **Pro:** N/A
* **Business:** N/A
* **Enterprise:** 62 days

### Full zone setup

**Link:** [Full zone setup](https://developers.cloudflare.com/dns/zone-setups/full-setup/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Partial zone setup

**Link:** [Partial zone setup](https://developers.cloudflare.com/dns/zone-setups/partial-setup/)

**Feature availability**

* **Free:** No
* **Pro:** No
* **Business:** Yes
* **Enterprise:** Yes

### DNS records management

**Link:** [DNS records management](https://developers.cloudflare.com/dns/manage-dns-records/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Number of records per zone**

* **Free:** 1,000 for zones created before `2024-09-01 00:00:00 UTC`\
  200 for zones created on or after `2024-09-01 00:00:00 UTC`
* **Pro:** 3,500
* **Business:** 3,500
* **Enterprise:** 3,500 (can be increased)

### DNS record comments

**Link:** [DNS record comments](https://developers.cloudflare.com/dns/manage-dns-records/reference/record-attributes/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Character limit**

* **Free:** 100
* **Pro:** 500
* **Business:** 500
* **Enterprise:** 500

**Comments per record**

* **Free:** 1
* **Pro:** 1
* **Business:** 1
* **Enterprise:** 1

### DNS record tags

**Link:** [DNS record tags](https://developers.cloudflare.com/dns/manage-dns-records/reference/record-attributes/)

**Feature availability**

* **Free:** No
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Name character limit (everything before the colon)**

* **Free:** N/A
* **Pro:** 32
* **Business:** 32
* **Enterprise:** 32

**Value character limit (everything after the colon)**

* **Free:** N/A
* **Pro:** 100
* **Business:** 100
* **Enterprise:** 100

**Tags per record**

* **Free:** N/A
* **Pro:** 20
* **Business:** 20
* **Enterprise:** 20

### DNS zone transfers

**Link:** [DNS zone transfers](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/)

**Feature availability**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

### Subdomain zone setup

**Link:** [Subdomain zone setup](https://developers.cloudflare.com/dns/zone-setups/subdomain-setup/)

**Feature availability**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

### Subdomain delegation

**Link:** [Subdomain delegation](https://developers.cloudflare.com/dns/manage-dns-records/how-to/subdomains-outside-cloudflare/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Reverse zones

**Link:** [Reverse zones](https://developers.cloudflare.com/dns/additional-options/reverse-zones/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes
