---
title: Available debug endpoints · Cloudflare DNS docs
description: The following debug endpoints are available via dig or other DNS query tools.
lastUpdated: 2025-11-06T14:23:21.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/troubleshooting/dns-debug-endpoints/
  md: https://developers.cloudflare.com/dns/troubleshooting/dns-debug-endpoints/index.md
---

The following debug endpoints are available via `dig` or other DNS query tools.

Note

For all commands, you can replace `alex.ns.cloudflare.com` with your Cloudflare assigned nameservers.

```sh
$ dig @alex.ns.cloudflare.com chaos txt myip.cloudflare +short
```

This command gives you your IP address, meaning the public IP address that Cloudflare receives this DNS query from. This is useful for debugging when you need to know your own IP.

***

```sh
$ dig @alex.ns.cloudflare.com chaos txt id.server +short
```

This command gives you the Cloudflare data center you are connecting to, for DNS queries sent from where you execute this command.

***

```sh
$ dig @alex.ns.cloudflare.com chaos txt version.bind +short
```

This command gives you the version of Cloudflare's authoritative DNS software that is running on the data center you are connected to. Usually, the same version would always be present on all of our data centers. But, since we do staged releases, technically there can be different versions on different data centers.

***

```sh
$ dig @alex.ns.cloudflare.com txt whoami.cloudflare.net +short
```

This command gives you your public IP (same as the first command above), your ASN, and the associated country code, all indicating where you are sending this query from.
