---
title: Configure the device agent · Cloudflare Learning Paths
description: The Cloudflare WARP client (known as the Cloudflare One Agent in
  mobile app stores) encrypts designated traffic from a user's device to
  Cloudflare's global network. In this learning path, we will first define all
  of your parameters and deployment rules, and then we will install and connect
  the client. If you prefer to start the client download now, refer to Download
  WARP.
lastUpdated: 2025-11-20T01:18:18.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/configure-device-agent/
  md: https://developers.cloudflare.com/learning-paths/secure-internet-traffic/configure-device-agent/index.md
---

The Cloudflare WARP client (known as the Cloudflare One Agent in mobile app stores) encrypts designated traffic from a user's device to Cloudflare's global network. In this learning path, we will first define all of your parameters and deployment rules, and then we will install and connect the client. If you prefer to start the client download now, refer to [Download WARP](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/).

Note

The following steps are identical to [Configure the device agent](https://developers.cloudflare.com/learning-paths/secure-internet-traffic/configure-device-agent/) in the Replace your VPN implementation guide. If you have already completed Replace your VPN, you can skip ahead to [Determine when to use PAC files](https://developers.cloudflare.com/learning-paths/secure-internet-traffic/configure-device-agent/pac-files/).

## Objectives

By the end of this module, you will be able to:

* Define which users can connect devices to your Zero Trust instance.
* Configure global and device-specific settings for the WARP client.
* Route user traffic through Cloudflare Gateway.
* Route domains to a private DNS server, if required.

Troubleshoot WARP

For step-by-step guidance on diagnosing and resolving WARP client issues, refer to the [WARP troubleshooting guide](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/troubleshooting-guide/). The guide covers:

* How to collect diagnostic logs via the Cloudflare dashboard or CLI
* How to review key configuration files
* Common misconfigurations and their fixes
* Best practices for filing support tickets
