---
title: Dynamic steering · Cloudflare Load Balancing docs
description: Dynamic steering uses health monitor data to identify the fastest
  pool for a given Cloudflare Region or data center.
lastUpdated: 2025-01-10T15:14:38.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/load-balancing/understand-basics/traffic-steering/steering-policies/dynamic-steering/
  md: https://developers.cloudflare.com/load-balancing/understand-basics/traffic-steering/steering-policies/dynamic-steering/index.md
---

**Dynamic steering** uses health monitor data to identify the fastest pool for a given Cloudflare Region or data center.

Dynamic steering creates Round Trip Time (RTT) profiles based on an exponential weighted moving average (EWMA) of RTT to determine the fastest pool. If there is no current RTT data for your pool in a region or colocation center, Cloudflare directs traffic to the pools in failover order.

RTT values are collected each time a health probe request is made and based on the response from the endpoint to the monitor request. When a request is made, Cloudflare inspects the RTT data and uses it to sort pools by their RTT values.

When enabling Dynamic steering the first time for a pool, allow 10 minutes for the change to take effect while Cloudflare builds an RTT profile for that pool.

For TCP health monitors, calculated latency may not reflect the true latency to the endpoint if you are terminating TCP at a cloud provider edge location.

The diagram below shows how Cloudflare would route traffic to the pool with the lowest EWMA among three regions: Eastern North America, Europe, and Australia. In this case, the ENAM pool is selected because it has the lowest RTT.

![Dynamic steering routes traffic to the fastest available pool](https://developers.cloudflare.com/_astro/traffic-steering-2.CEeFHZfg_Z2bHxLO.webp)

Note

To ensure dynamic steering works as expected, the [Health Monitor Region](https://developers.cloudflare.com/load-balancing/monitors/#health-monitor-regions) must be set to **All Regions**. The Enterprise-only **All Data Centers** option is also a viable alternative.
