---
title: Page Rules settings · Cloudflare Rules docs
description: Settings control the action Cloudflare takes once a request matches
  the URL pattern defined in a page rule. You can use settings to enable and
  disable multiple Cloudflare features across the dashboard.
lastUpdated: 2025-09-15T16:47:39.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/page-rules/reference/settings/
  md: https://developers.cloudflare.com/rules/page-rules/reference/settings/index.md
---

Settings control the action Cloudflare takes once a request matches the URL pattern defined in a page rule. You can use settings to enable and disable multiple Cloudflare features across the dashboard.

Note

Consider alternative [Rules](https://developers.cloudflare.com/rules/) options due to their enhanced configurability. Refer to the [migration guide](https://developers.cloudflare.com/rules/reference/page-rules-migration/) for details.

For more flexibility and customization, consider using [Snippets](https://developers.cloudflare.com/rules/snippets/).

Note that:

* Some settings require a Pro, Business, or Enterprise domain plan.
* You can specify more than one setting to apply when the rule triggers.

The available Page Rules settings are the following:

| **Setting** | **Description** | **Plans** |
| - | - | - |
| [Always Use HTTPS](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/always-use-https/) | Enable **Always Use HTTPS** feature. If enabled, any `http://` URL is converted to `https://` through a 301 redirect. If this option does not appear, you do not have an active **Edge Certificate**. | All |
| [Automatic HTTPS Rewrites](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/automatic-https-rewrites/) | Turn on or off **Automatic HTTPS Rewrites**.NoteTo use this feature on specific hostnames - instead of across your entire zone - use a [configuration rule](https://developers.cloudflare.com/rules/configuration-rules/). | All |
| [Browser Cache TTL](https://developers.cloudflare.com/cache/how-to/edge-browser-cache-ttl/) | Control how long resources cached by client browsers remain valid. The Cloudflare dashboard and the API both prohibit setting **Browser Cache TTL** to `0` for non-Enterprise domains. | All |
| [Browser Integrity Check](https://developers.cloudflare.com/waf/tools/browser-integrity-check/) | Inspect the visitor's browser for headers commonly associated with spammers and certain bots.NoteTo use this feature on specific hostnames - instead of across your entire zone - use a [configuration rule](https://developers.cloudflare.com/rules/configuration-rules/).  | All |
| Bypass Cache on Cookie | Bypass cache and fetch resources from the origin server if a regular expression matches against a cookie name present in the request. If you add both this setting and the *Cache On Cookie* setting to the same page rule, *Cache On Cookie* takes precedence over *Bypass Cache on Cookie*. Refer to the [Additional details](https://developers.cloudflare.com/rules/page-rules/reference/additional-reference/#bypass-cache-on-cookie-setting) to learn about limited regular expression support. | Business and Enterprise |
| [Cache By Device Type](https://developers.cloudflare.com/cache/how-to/cache-rules/examples/cache-device-type/) | Separate cached content based on the visitor’s device type.  | Enterprise |
| [Cache Deception Armor](https://developers.cloudflare.com/cache/cache-security/cache-deception-armor/) | Protect from web cache deception attacks while still allowing static assets to be cached. This setting verifies that the URL's extension matches the returned *Content-Type*.  | All |
| Cache Level | Apply custom caching based on the option selected: – **Bypass**: Cloudflare does not cache. – **No Query String**: Delivers resources from cache when there is no query string. – **Ignore Query String**: Delivers the same resource to everyone independent of the query string. – **Standard**: Caches all static content that has a query string. – **Cache Everything**: Treats all content as static and caches all file types beyond the [Cloudflare default cached content](https://developers.cloudflare.com/cache/concepts/default-cache-behavior/#default-cached-file-extensions). Respects cache headers from the origin web server unless **Edge Cache TTL** is also set in the Page Rule. When combined with an **Edge Cache TTL** > `0`, **Cache Everything** removes cookies from the origin web server response.  | All |
| Cache on Cookie | Apply the *Cache Everything* option (*Cache Level* setting) based on a regular expression match against a cookie name. If you add both this setting and *Bypass Cache on Cookie* to the same page rule, *Cache On Cookie* takes precedence over *Bypass Cache on Cookie*. | Business and above |
| [Cache TTL by Status Code](https://developers.cloudflare.com/cache/how-to/configure-cache-status-code/) | Enterprise customers can set cache time-to-live (TTL) based on the response status from the origin web server. Cache TTL refers to the duration of a resource in the Cloudflare network before being marked as stale or discarded from cache. Status codes are returned by a resource's origin. Setting cache TTL based on response status overrides the default cache behavior (standard caching) for static files and overrides cache instructions sent by the origin web server. To cache non-static assets, set a Cache Level of Cache Everything using a Page Rule. Setting no-store Cache-Control or a low TTL (using `max-age`/`s-maxage`) increases requests to origin web servers and decreases performance. | Enterprise |
| [Custom Cache Key](https://developers.cloudflare.com/cache/how-to/cache-keys/) | Control specifically what variables to include when deciding which resources to cache. This allows customers to determine what to cache based on something other than just the URL. | Enterprise |
| Disable Zaraz | Turn off [Zaraz](https://developers.cloudflare.com/zaraz/).NoteTo use this feature on specific hostnames - instead of across your entire zone - use a [configuration rule](https://developers.cloudflare.com/rules/configuration-rules/). | All |
| Edge Cache TTL | Specify how long to cache a resource in the Cloudflare global network. *Edge Cache TTL* is not visible in response headers. | All |
| [Email Obfuscation](https://developers.cloudflare.com/waf/tools/scrape-shield/email-address-obfuscation/) | Turn on or off **Email Obfuscation**.NoteTo use this feature on specific hostnames - instead of across your entire zone - use a [configuration rule](https://developers.cloudflare.com/rules/configuration-rules/). | All |
| Forwarding URL | Redirects one URL to another using an `HTTP 301/302` redirect. Refer to [Wildcard matching and referencing](https://developers.cloudflare.com/rules/page-rules/reference/wildcard-matching/). | All |
| Host Header Override | Apply a specific host header.NoteYou can accomplish the same effect with an [origin rule](https://developers.cloudflare.com/rules/origin-rules/features/#host-header). | Enterprise |
| IP Geolocation Header | Cloudflare adds a `CF-IPCountry` HTTP header containing the country code that corresponds to the visitor. | All |
| [Mirage](https://developers.cloudflare.com/speed/optimization/images/mirage/) | Turn on or off **Mirage** (deprecated).NoteTo use this feature on specific hostnames - instead of across your entire zone - use a [configuration rule](https://developers.cloudflare.com/rules/configuration-rules/). | Pro and above |
| [Opportunistic Encryption](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/opportunistic-encryption/) | Turn on or off the **Opportunistic Encryption**.NoteTo use this feature on specific hostnames - instead of across your entire zone - use a [configuration rule](https://developers.cloudflare.com/rules/configuration-rules/).  | All |
| [Origin Cache Control](https://developers.cloudflare.com/cache/concepts/cache-control/) | Origin Cache Control is enabled by default for Free, Pro, and Business domains and disabled by default for Enterprise domains. | All |
| Origin Error Page Pass-thru | Turn on or off Cloudflare error pages generated from issues sent from the origin server. If enabled, this setting triggers error pages issued by the origin. | Enterprise |
| [Polish](https://developers.cloudflare.com/images/polish/) | Apply options from the **Polish** feature of the Cloudflare **Speed** app.NoteTo use this feature on specific hostnames - instead of across your entire zone - use a [configuration rule](https://developers.cloudflare.com/rules/configuration-rules/). | Pro and above |
| [Query String Sort](https://developers.cloudflare.com/cache/advanced-configuration/query-string-sort/) | Turn on or off the reordering of query strings. When query strings have the same structure, caching improves. | Enterprise |
| Resolve Override | Change the origin address to the value specified in this setting.NoteYou can accomplish the same effect with an [origin rule](https://developers.cloudflare.com/rules/origin-rules/features/#dns-record). | Enterprise |
| [Respect Strong ETags](https://developers.cloudflare.com/cache/reference/etag-headers/) | Turn on or off byte-for-byte equivalency checks between the Cloudflare cache and the origin server. | Enterprise |
| Response Buffering | Turn on or off whether Cloudflare should wait for an entire file from the origin server before forwarding it to the site visitor. By default, Cloudflare sends packets to the client as they arrive from the origin server. | Enterprise |
| [Rocket Loader](https://developers.cloudflare.com/speed/optimization/content/rocket-loader/) | Turn on or off **Rocket Loader** in the Cloudflare **Speed** app.NoteTo use this feature on specific hostnames - instead of across your entire zone - use a [configuration rule](https://developers.cloudflare.com/rules/configuration-rules/). | All |
| [SSL](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/) | Control options for the **SSL** feature of the **Edge Certificates** tab in the Cloudflare **SSL/TLS** app.NoteTo use this feature on specific hostnames - instead of across your entire zone - use a [configuration rule](https://developers.cloudflare.com/rules/configuration-rules/). | All |
| True Client IP Header | Turn on or off the [**True-Client-IP Header**](https://developers.cloudflare.com/network/true-client-ip-header/) feature of the Cloudflare **Network** app.  | Enterprise |
