---
title: CURL · Cloudflare Style Guide
description: The CURL component is used to display a cURL command for making HTTP requests.
lastUpdated: 2025-04-22T19:07:40.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/curl/
  md: https://developers.cloudflare.com/style-guide/components/curl/index.md
---

The `CURL` component is used to display a cURL command for making HTTP requests.

## Import

```mdx
import { CURL } from "~/components";
```

## Usage

## `<CURL>` Props

### `url`

**required**

**type:** `string`

The URL to make the request to.

### `method`

**type:** `"GET" | "HEAD" | "POST" | "PUT" | "DELETE" | "OPTIONS" | "PATCH"`

**default:** `"GET"`

The HTTP method to use for the request.

### `headers`

**type:** `Record<string, string>`

The headers to include in the request.

### `json`

**type:** `Record<string, any> | Record<string, any>[]`

JSON data to include in the request.

### `form`

**type:** `Record<string, any>`

The FormData payload to send.

### `query`

**type:** `Record<string, string | string[]>`

URL query parameters to append to the request URL.

### `code`

**type:** `object`

An object of Expressive Code props, the following props are available:

* [Base Props](https://expressive-code.com/key-features/code-component/#available-props)
* [Line Marker Props](https://expressive-code.com/key-features/text-markers/#props)
* [Collapsible Sections Props](https://expressive-code.com/plugins/collapsible-sections/#props)
