---
title: Intended audience · Cloudflare Style Guide
description: Summary of who the content is aimed at and what users will learn.
  When combined with an Introduction, the purpose is to provide users with an
  understanding of what the page is about and whether the content is relevant
  for their role.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/intended-audience/
  md: https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/intended-audience/index.md
---

## Definition

Summary of who the content is aimed at and what users will learn. When combined with an [Introduction](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/introduction/), the purpose is to provide users with an understanding of what the page is about and whether the content is relevant for their role.

## Used in

[Reference architecture](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/reference-architecture/), [Design guide](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/design-guide/)

## Structure

Begin with the subtitle **Who is this for?**

Usually 1-3 paragraphs. The first paragraph should describe the type of person this document was written for. If the document relies on existing knowledge, link to 3-5 other resources the reader can consume prior to reading this document. The final paragraph should contain 2-3 specific bullets on what the reader is going to learn from this document.

## Examples

**Who is this for?**

This reference architecture is designed for IT or security professionals with some responsibility over or familiarity with their organization’s existing infrastructure. It is useful to have some experience with technologies important to securing hybrid work, including identity providers (IdPs), user directories, single sign on (SSO), endpoint security or management (EPP, XDR, UEM, MDM), firewalls, routers, and point solutions like packet or content inspection hardware, threat prevention, and data loss prevention technologies.

To build a stronger baseline understanding of Cloudflare, we recommend the following resources:

* What is Cloudflare? | Website (5 minute read) or video (2 minutes)
* Solution Brief: Cloudflare One (3 minute read)
* Whitepaper: Reference Architecture for Internet-Native Transformation (10 minute read)
* Blog: Zero Trust, SASE, and SSE: foundational concepts for your next-generation network (14 minute read)

Those who read this reference architecture will learn:

* How Cloudflare One protects an organization’s employees, devices, applications, data, and networks
* How Cloudflare One fits into your existing infrastructure, and how to approach migration to a SASE architecture
* How to plan for deploying Cloudflare One

While this document examines Cloudflare One at a technical level, it does not offer fine detail about every product in the platform. Instead, it looks at how all the services in Cloudflare One enable networking and network security to be consolidated on one architecture. Visit the developer documentation for further information specific to a product area or use case.
